package cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * kryo序列化工具
 * Created by guoyanfei .
 * 2019-04-18 .
 */
@Slf4j
public class KryoSerializer {

    private static final int BUFFER_SIZE = 4096 * 4;

    private static ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> new Kryo());

    private KryoSerializer() {
    }

    /**
     * 反序列化
     * @param bytes
     * @return
     */
    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Input input = new Input(in, BUFFER_SIZE);
        Object obj = kryo.readClassAndObject(input);
        input.close();
        return obj;
    }

    /**
     * 序列化
     * @param object
     * @return
     */
    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output(out, BUFFER_SIZE);
        kryo.writeClassAndObject(output, object);
        output.close();
        return out.toByteArray();
    }

}
