/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowReplayTrace
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FlowReplayTrace.class);
    private static final long serialVersionUID = -622886226087802579L;
    private String traceId;
    private FlowReplaySpan mainSpan;
    private List<FlowReplaySpan> subSpans;

    public static synchronized void createTrace(FlowReplaySpan mainSpan) {
        if (mainSpan == null) {
            return;
        }
        FlowReplayTrace c = new FlowReplayTrace();
        c.traceId = UUIDUtils.createUUID();
        c.mainSpan = mainSpan;
        c.subSpans = Collections.synchronizedList(new LinkedList());
        ThreadLocalHolder.threadLocal2FlowReplayTrace.set(c);
    }

    public static synchronized void addSubSpan(FlowReplaySpan subSpan) {
        FlowReplayTrace trace = (FlowReplayTrace)ThreadLocalHolder.threadLocal2FlowReplayTrace.get();
        if (trace == null || trace.subSpans == null) {
            return;
        }
        trace.subSpans.add(subSpan);
    }

    public static String getCurrentTraceId() {
        FlowReplayTrace trace = (FlowReplayTrace)ThreadLocalHolder.threadLocal2FlowReplayTrace.get();
        if (trace == null) {
            return null;
        }
        return trace.traceId;
    }

    public static boolean isTraced() {
        return RecordContextHolder.isRecording() && FlowReplayTrace.get() != null;
    }

    public static FlowReplayTrace get() {
        FlowReplayTrace trace = (FlowReplayTrace)ThreadLocalHolder.threadLocal2FlowReplayTrace.get();
        if (trace == null) {
            return null;
        }
        return trace;
    }

    public static void remove() {
        ThreadLocalHolder.threadLocal2FlowReplayTrace.remove();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public FlowReplaySpan getMainSpan() {
        return this.mainSpan;
    }

    public List<FlowReplaySpan> getSubSpans() {
        return this.subSpans;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setMainSpan(FlowReplaySpan mainSpan) {
        this.mainSpan = mainSpan;
    }

    public void setSubSpans(List<FlowReplaySpan> subSpans) {
        this.subSpans = subSpans;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowReplayTrace)) {
            return false;
        }
        FlowReplayTrace other = (FlowReplayTrace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        FlowReplaySpan this$mainSpan = this.getMainSpan();
        FlowReplaySpan other$mainSpan = other.getMainSpan();
        if (this$mainSpan == null ? other$mainSpan != null : !this$mainSpan.equals(other$mainSpan)) {
            return false;
        }
        List<FlowReplaySpan> this$subSpans = this.getSubSpans();
        List<FlowReplaySpan> other$subSpans = other.getSubSpans();
        return !(this$subSpans == null ? other$subSpans != null : !((Object)this$subSpans).equals(other$subSpans));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowReplayTrace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        FlowReplaySpan $mainSpan = this.getMainSpan();
        result = result * 59 + ($mainSpan == null ? 43 : $mainSpan.hashCode());
        List<FlowReplaySpan> $subSpans = this.getSubSpans();
        result = result * 59 + ($subSpans == null ? 43 : ((Object)$subSpans).hashCode());
        return result;
    }

    public String toString() {
        return "FlowReplayTrace(traceId=" + this.getTraceId() + ", mainSpan=" + this.getMainSpan() + ", subSpans=" + this.getSubSpans() + ")";
    }

    private static class ThreadLocalHolder {
        private static final ThreadLocal<FlowReplayTrace> threadLocal2FlowReplayTrace = new ThreadLocal();

        private ThreadLocalHolder() {
        }
    }
}

