/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.CustomizeCallbackFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowReplayUtils {
    private static final Logger log = LoggerFactory.getLogger(FlowReplayUtils.class);
    private static final String DUIBA_FLOW_REPLAY_REPORT_ID = System.getenv("DUIBA_FLOW_REPLAY_REPORT_ID");

    private FlowReplayUtils() {
    }

    public static boolean isJSONValid(String json) {
        if (json == null) {
            return false;
        }
        if (!json.startsWith("{") && !json.startsWith("[")) {
            return false;
        }
        try {
            JSONObject.parseObject((String)json);
        }
        catch (Exception e0) {
            try {
                JSONObject.parseArray((String)json);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isReplayEnv() {
        return StringUtils.isNotBlank((CharSequence)DUIBA_FLOW_REPLAY_REPORT_ID);
    }

    public static boolean isReportIdValid(Long reportId) {
        if (StringUtils.isBlank((CharSequence)DUIBA_FLOW_REPLAY_REPORT_ID)) {
            return false;
        }
        return DUIBA_FLOW_REPLAY_REPORT_ID.equals(String.valueOf(reportId));
    }

    public static String parseApiNameByMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, method.getDeclaringClass());
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        Class<?>[] parametersTypes = method.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    public static boolean isMethodEqual(String spanMethod, Method currentMethod) {
        return spanMethod.equals(currentMethod.getName());
    }

    public static boolean isArgumentsTypesEqual(String[] spanParameterTypes, Class<?>[] currentParameterTypes) {
        for (int i = 0; i < currentParameterTypes.length; ++i) {
            if (currentParameterTypes[i].getName().equals(spanParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static String stringArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return Joiner.on((String)",").join((Object[])stringArray);
    }

    public static String classArrayToString(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>(classArray.length);
        for (Class<?> c : classArray) {
            classNames.add(c.getName());
        }
        return Joiner.on((String)",").join(classNames);
    }

    public static boolean isArgumentsEqual(Object[] spanParameterValues, Object[] currentParameterValues) {
        for (int i = 0; i < currentParameterValues.length; ++i) {
            Object arg = currentParameterValues[i];
            Object spanArg = spanParameterValues[i];
            if (FlowReplayUtils.isObjectEqual(JSON.toJSON((Object)spanArg), JSON.toJSON((Object)arg))) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeEqual(String spanReturnType, Class<?> currentReturnType) {
        if (spanReturnType == null && currentReturnType == null) {
            return true;
        }
        if (currentReturnType != null) {
            return currentReturnType.getName().equals(spanReturnType);
        }
        return false;
    }

    public static boolean isTypeFullPathEqual(String spanTypeFullPath, String currentTypeFullPath) {
        return Objects.equals(spanTypeFullPath, currentTypeFullPath);
    }

    public static boolean isGlobalWhitelist(Object[] allArguments) {
        if (allArguments != null) {
            for (Object obj : allArguments) {
                if (obj == null || !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(obj.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isObjectEqual(Object recordVal, Object replayVal) {
        if (recordVal == null && replayVal == null) {
            return true;
        }
        if (recordVal instanceof byte[] && replayVal instanceof byte[]) {
            return Arrays.equals((byte[])recordVal, (byte[])replayVal);
        }
        if (recordVal instanceof String && replayVal instanceof String) {
            return recordVal.equals(replayVal);
        }
        if (recordVal instanceof JSONArray && replayVal instanceof JSONArray) {
            return FlowReplayUtils.isJSONArrayEqual((JSONArray)recordVal, (JSONArray)replayVal);
        }
        if (recordVal instanceof JSONObject && replayVal instanceof JSONObject) {
            return FlowReplayUtils.isJSONObjectEqual((JSONObject)recordVal, (JSONObject)replayVal);
        }
        if (recordVal != null) {
            return recordVal.equals(replayVal);
        }
        return false;
    }

    private static boolean isJSONArrayEqual(JSONArray recordArray, JSONArray replayArray) {
        if (recordArray.size() != replayArray.size()) {
            return false;
        }
        Iterator iterator = recordArray.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object recordValue = iterator.next();
            String recordValueStr = String.valueOf(recordValue);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                return FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)String.valueOf(recordArray.get(i))));
            }
            if (!Objects.equals(recordValue, replayArray.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isJSONObjectEqual(JSONObject recordObj, JSONObject replayObj) {
        for (Map.Entry entry : recordObj.entrySet()) {
            Object recordValue = entry.getValue();
            Object replayValue = replayObj.get(entry.getKey());
            String recordValueStr = String.valueOf(recordValue);
            String replayValueStr = String.valueOf(replayValue);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                return FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr));
            }
            if (Objects.equals(recordValue, replayValue)) continue;
            return false;
        }
        return true;
    }

    public static String parseApiNameByMethodSignature(MethodSignature methodSignature) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, methodSignature.getDeclaringType());
        sb.append(".");
        sb.append(methodSignature.getMethod().getName());
        sb.append("(");
        Class[] parametersTypes = methodSignature.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    private static void appendTypes(StringBuilder sb, Class<?>[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            FlowReplayUtils.appendType(sb, types[i]);
            if (i >= size - 1) continue;
            sb.append(",");
        }
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type.isArray()) {
            FlowReplayUtils.appendType(sb, type.getComponentType());
            sb.append("[]");
        } else {
            sb.append(type.getSimpleName());
        }
    }

    public static <T> T executeCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        if (StringUtils.isBlank((CharSequence)key)) {
            return callback.invoke();
        }
        if (FlowReplayTrace.isTraced()) {
            return FlowReplayUtils.recordCustomizeCallbackSpan(key, callback);
        }
        if (FlowReplayUtils.isReplayEnv() && ReplayTraceContext.isReplaying()) {
            return FlowReplayUtils.repalyCustomizeCallbackSpan(key, callback);
        }
        return callback.invoke();
    }

    private static <T> T repalyCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("CustomizeCallback\u56de\u653e_traceId={}_spanType={}_spanId={}", new Object[]{ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null});
        if (span == null || SpanType.CUSTOMIZE != span.getSpanType()) {
            String expert = SpanType.CUSTOMIZE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        CustomizeCallbackFlowReplaySpan customizeCallbackSpan = (CustomizeCallbackFlowReplaySpan)span;
        if (!key.equals(customizeCallbackSpan.getKey())) {
            String expert = customizeCallbackSpan.getKey();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_800, expert, key);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        return (T)customizeCallbackSpan.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T recordCustomizeCallbackSpan(String key, Callback<T> callback) throws Throwable {
        if (IgnoreSubInvokesContext.isMarked()) {
            return callback.invoke();
        }
        IgnoreSubInvokesContext.keyMark(key);
        T ret = callback.invoke();
        try {
            CustomizeCallbackFlowReplaySpan span = CustomizeCallbackFlowReplaySpan.createSpan(key, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("CustomizeCallback\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("CustomizeCallback_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    public static interface Callback<R> {
        public R invoke() throws Throwable;
    }
}

