/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RandomFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordRandomMethodInterceptor
implements StaticMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordRandomMethodInterceptor.class);

    private boolean canRecord(Method method, Object[] allArguments) {
        if (!FlowReplayTrace.isTraced()) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        if (!this.canRecord(method, allArguments)) {
            return;
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return;
        }
        IgnoreSubInvokesContext.staticMark(clazz, method, allArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        if (!this.canRecord(method, allArguments)) {
            return ret;
        }
        if (!IgnoreSubInvokesContext.isStaticMarked(clazz, method, allArguments)) {
            return ret;
        }
        try {
            RandomFlowReplaySpan span = RandomFlowReplaySpan.createSpan(method, allArguments, parameterTypes, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("Random\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("Random_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }
}

