/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import java.lang.instrument.Instrumentation;
import mockit.Mock;
import mockit.MockUp;
import mockit.internal.startup.Startup;
import net.bytebuddy.agent.ByteBuddyAgent;

public class ReplayClockMockSupport {
    private static final long REAL_START_MILLIS = System.currentTimeMillis();
    private static final long REAL_START_NANOS = System.nanoTime();
    private static volatile long OFFSET_MILLIS = 0L;

    private static void init() {
        MockUp<System> systemMockUp = new MockUp<System>(){

            @Mock
            public long currentTimeMillis() {
                return ReplayClockMockSupport.millisSinceClassInit() + REAL_START_MILLIS + OFFSET_MILLIS;
            }
        };
    }

    private static long millisSinceClassInit() {
        return (System.nanoTime() - REAL_START_NANOS) / 1000000L;
    }

    public static void setOffsetMillis(long offsetMillis) {
        OFFSET_MILLIS = offsetMillis;
    }

    static {
        if (FlowReplayUtils.isReplayEnv()) {
            Startup.premain(null, (Instrumentation)ByteBuddyAgent.install());
            ReplayClockMockSupport.init();
        }
    }
}

