/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.CustomizeFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

@Aspect
public class ReplayCustomizeFlowReplaySpanAspect {
    private static final Logger log = LoggerFactory.getLogger(ReplayCustomizeFlowReplaySpanAspect.class);

    @Around(value="execution(* *.*(..)) && @annotation(cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan)")
    public Object customizeSpanReplayAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        FlowReplayCustomizeSpan customizeSpanAnno = signature.getMethod().getAnnotation(FlowReplayCustomizeSpan.class);
        if (customizeSpanAnno == null) {
            return joinPoint.proceed();
        }
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return joinPoint.proceed();
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("Customize\u56de\u653e_traceId={}_spanType={}_spanId={}", new Object[]{ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null});
        if (span == null || SpanType.CUSTOMIZE != span.getSpanType()) {
            String expert = SpanType.CUSTOMIZE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        CustomizeFlowReplaySpan customizeSpan = (CustomizeFlowReplaySpan)span;
        Method method = signature.getMethod();
        Object[] parameterValues = joinPoint.getArgs();
        if (!FlowReplayUtils.isMethodEqual(customizeSpan.getMethodName(), method)) {
            String expert = customizeSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_701, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(customizeSpan.getParameterTypes(), method.getParameterTypes())) {
            String expert = FlowReplayUtils.stringArrayToString(customizeSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(method.getParameterTypes());
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_702, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            if (!FlowReplayUtils.isArgumentsEqual(customizeSpan.getParameterValues(), parameterValues)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_703);
                throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_706, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isReturnTypeEqual(customizeSpan.getReturnType(), method.getReturnType())) {
            String expert = customizeSpan.getReturnType();
            String actual = method.getReturnType() != null ? method.getReturnType().getName() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_704, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isTypeFullPathEqual(customizeSpan.getTypeFullPath(), signature.getDeclaringTypeName())) {
            String expert = customizeSpan.getTypeFullPath();
            String actual = signature.getDeclaringTypeName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_705, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            return customizeSpan.getReturnValue();
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_707, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }
}

