/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import javax.annotation.Resource;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

class HttpClientCloseMethodInterceptor
implements HttpClientMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientCloseMethodInterceptor.class);
    private volatile boolean canClose = false;
    @Resource
    private ApplicationContext applicationContext;

    HttpClientCloseMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!"close".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        if (this.canClose) {
            return invocation.proceed();
        }
        log.warn("", (Throwable)new IllegalStateException("\u8bf7\u52ff\u5728\u5e94\u7528\u4e2d\u8c03\u7528\u7edf\u4e00HttpClient.close()\u65b9\u6cd5!"));
        return null;
    }

    public int getOrder() {
        return 1;
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onContextClosed(ContextClosedEvent e) {
        if (e.getApplicationContext() == this.applicationContext) {
            this.canClose = true;
        }
    }
}

