/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.BeanNameAware;

public class MessageListenerConcurrentlyWrapper
implements MessageListenerConcurrently,
BeanNameAware {
    private MessageListenerConcurrently source;
    private String beanName;

    public MessageListenerConcurrentlyWrapper(MessageListenerConcurrently source, String beanName) {
        this.source = source;
        this.beanName = beanName;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        DBTimeProfile.start();
        try {
            ConsumeConcurrentlyStatus consumeConcurrentlyStatus = CatUtils.executeInCatTransaction(() -> this.source.consumeMessage(msgs, context), "MessageQueue", "RocketMQ.consume");
            return consumeConcurrentlyStatus;
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            DBTimeProfile.end((String)"RocketMQ.consume");
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }
}

