package cn.com.duibaboot.ext.autoconfigure.javaagent.common;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginResourcesResolver;
import com.google.common.base.Joiner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public interface AgentPluginExtSpi {
    /**
     * 获取多个interceptor类名，多个用逗号隔开。
     * @param key
     * @return
     */
    default String getInterceptorClassNames(String key){
        PluginResourcesResolver resolver = new PluginResourcesResolver();
        List<URL> urls = resolver.getResources("agent-plugin-ext.def");
        if (urls == null || urls.isEmpty()) {
            return null;
        }
        List<String> interceptorClassNames = new ArrayList<>();
        for(URL url : urls){
            try(BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()))){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) {
                        continue;
                    }
                    String[] lineArr = line.split("=");
                    if(key.equals(lineArr[0])){
                        interceptorClassNames.add(lineArr[1]);
                    }
                }
            } catch (IOException e){
                throw new RuntimeException(e);
            }
        }
        return Joiner.on(",").skipNulls().join(interceptorClassNames);
    }
}
