package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * traceMap用于存放回放过程中的trace，在httpClient发起请求之前设置。在请求的filter中获取出来，用于后续的回放流程。
 * Created by guoyanfei .
 * 2019-03-15 .
 */
public class FlowReplayTraceMapHolder {

    /**
     * key: traceId
     * value: trace
     */
    private static Map<String, FlowReplayTrace> traceMap = new ConcurrentHashMap<>();

    public static FlowReplayTrace getAndRemove(String traceId) {
        return traceMap.remove(traceId);
    }

    public static void put(FlowReplayTrace trace) {
        traceMap.putIfAbsent(trace.getTraceId(), trace);
    }
}
