package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.*;

import java.net.URI;

public class SsreRestTemplateWrapper extends RestTemplate implements ClientWrapper {

    @Override
    public boolean trySetClient(Object client) {
        if(client==null || !RestTemplate.class.isAssignableFrom(client.getClass())){
            return false;
        }
        BeanUtils.copyProperties(client,this);
        return true;
    }

    @Override
    public Class acceptableClass() {
        return RestOperations.class;
    }

    @Override
    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        SsreUtils.checkSsre(url);
        return super.doExecute(url, method, requestCallback, responseExtractor);
    }
}
