package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.bytebuddy.AbstractJunction;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.IndirectMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

import java.util.*;

import static net.bytebuddy.matcher.ElementMatchers.isInterface;
import static net.bytebuddy.matcher.ElementMatchers.not;

/**
 * The <code>PluginFinder</code> represents a finder , which assist to find the one
 * from the given {@link AbstractClassEnhancePluginDefine} list.
 *
 */
public class PluginFinder {
    private final Map<String, List<AbstractClassEnhancePluginDefine>> nameMatchDefine = new HashMap<>();
    private final List<AbstractClassEnhancePluginDefine> signatureMatchDefine = new LinkedList<>();

    public PluginFinder(List<AbstractClassEnhancePluginDefine> plugins) {
        for (AbstractClassEnhancePluginDefine plugin : plugins) {
            ClassMatch match = plugin.enhanceClass();

            if (match == null) {
                continue;
            }

            if (match instanceof NameMatch) {
                NameMatch nameMatch = (NameMatch)match;
                List<AbstractClassEnhancePluginDefine> list = nameMatchDefine.get(nameMatch.getClassName());
                if(list == null){
                    list = new ArrayList<>();
                    nameMatchDefine.put(nameMatch.getClassName(), list);
                }
                list.add(plugin);
            } else {
                signatureMatchDefine.add(plugin);
            }
        }
    }

    public List<AbstractClassEnhancePluginDefine> find(TypeDescription typeDescription,
                                                 ClassLoader classLoader) {
        List<AbstractClassEnhancePluginDefine> list = new ArrayList<>();
        String typeName = typeDescription.getTypeName();
        if (nameMatchDefine.containsKey(typeName)) {
            list.addAll(nameMatchDefine.get(typeName));
        }


        for (AbstractClassEnhancePluginDefine pluginDefine : signatureMatchDefine) {
            IndirectMatch match = (IndirectMatch)pluginDefine.enhanceClass();
            if (match.isMatch(typeDescription)) {
                list.add(pluginDefine);
            }
        }
        return list;
    }

    public ElementMatcher buildMatch() {
        ElementMatcher.Junction judge = new AbstractJunction<NamedElement>() {
            @Override
            public boolean matches(NamedElement target) {
                return nameMatchDefine.containsKey(target.getActualName());
            }
        };
        judge = judge.and(not(isInterface()));
        for (AbstractClassEnhancePluginDefine define : signatureMatchDefine) {
            ClassMatch match = define.enhanceClass();
            if (match instanceof IndirectMatch) {
                judge = judge.or(((IndirectMatch)match).buildJunction());
            }
        }
        return judge;
    }
}
