package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import com.google.common.cache.Cache;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Objects;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-17 15:55
 * @descript:
 * @version: 1.0
 */
@Configuration
@EnableAsync
@ConditionalOnClass({Cache.class})
public class GuavaCacheMonitor {

    private static final String path = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("")).getFile();

    private static final LocalPersistenceService persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(path, "monitor")));

    private static final PersistentUserManagedCache<String, Object> monitorCache = UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, Object.class)
            .with(new UserManagedPersistenceContext<>("monitorCache", persistenceService))
            .withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder()
                    .heap(10L, EntryUnit.ENTRIES)
                    .disk(10L, MemoryUnit.MB, true))
            .build(true);

    @Configuration
    public static class GuavaCacheVariables implements ApplicationContextAware {

        private ApplicationContext appContext;

        @Async
        @EventListener(MainContextRefreshedEvent.class)
        public void loadAllCacheBean() {

            String[] beans = appContext.getBeanDefinitionNames();
            for (String bean : beans) {

                Field[] fields = bean.getClass().getDeclaredFields();
                if (fields.length == 0) {
                    continue;
                }

                Object beanObj = appContext.getBean(bean);
                for (Field field : fields) {

                    if (field.getType().isAssignableFrom(Cache.class)) {
                        field.setAccessible(true);

                        try {
                            monitorCache.put(field.getName(), field.get(beanObj));
                        } catch (IllegalAccessException e) {
                            //ignore
                        }
                    }

                }

            }
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.appContext = applicationContext;
        }
    }


}
