package cn.com.duibaboot.ext.autoconfigure.web.container;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

import javax.servlet.ServletException;
import java.io.IOException;

/**
 * //添加server.tomcat.protocol_header=x-forwarded-proto这个头用于支持https后会带来一个副作用
 *         //RemoteIpValue类里会把X-Forwarded-For头中从右数起第一个公网ip赋值给RemoteAddr，导致原有的两个字段在程序里获取到后都会发生变化，程序如果想通过request.getRemoteAddr()获取最近代理ip成为不可能。
 *         //加入如下自定义Value的作用就是为了在RemoteIpValue生效前把原始的X-Forwarded-For值和RemoteAddr记下来。
 */
public class TomcatIpRecordValve extends ValveBase {

    public static final String ORIGINAL_REMOTE_ADDR = "originalRemoteAddr";
    public static final String ORIGINAL_X_FORWARDED_FOR = "originalXForwardedFor";

    public TomcatIpRecordValve() {
        super(true);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String originalRemoteAddr = request.getRemoteAddr();
        String originalXForwardedFor = request.getHeader("X-Forwarded-For");//ip0, proxyIp1, proxyIp2

        //在RemoteIpValue改变上述两个值前把这两个值记录下来
        request.setAttribute(ORIGINAL_REMOTE_ADDR, originalRemoteAddr);
        request.setAttribute(ORIGINAL_X_FORWARDED_FOR, originalXForwardedFor);

        getNext().invoke(request, response);
    }

}
