/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthElasticSearchPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.createSpan("elasticsearch:/" + methodName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ElasticsearchOperations").append(".").append(methodName);
        try {
            span.tag("elasticsearch.class_method", stringBuilder.toString());
            span.tag("lc", "ElasticsearchOperations");
            span.tag("peer.service", "Elasticsearch");
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }
}

