/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RemoteServiceFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class RemoteServiceReplayer
implements Replayer {
    @Resource
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        RemoteServiceFlowReplaySpan span = (RemoteServiceFlowReplaySpan)trace.getMainSpan();
        Object obj = this.applicationContext.getBean(RemoteServiceReplayer.toLowerCaseFirstOne(span.getTypeName()));
        ReplayTraceContext.create(trace);
        ReplayTraceContext context = null;
        Object replayResultValue = null;
        try {
            String[] parameterTypes = span.getParameterTypes();
            int parameterLength = parameterTypes.length;
            Class[] parameterTypeClasses = null;
            if (parameterLength > 0) {
                parameterTypeClasses = new Class[parameterLength];
                for (int i = 0; i < parameterLength; ++i) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i]);
                }
            }
            Method method = ReflectionUtils.findMethod(obj.getClass(), (String)span.getMethodName(), (Class[])parameterTypeClasses);
            replayResultValue = ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])span.getParameterValues());
        }
        catch (ClassNotFoundException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_300);
        }
        finally {
            context = ReplayTraceContext.getAndRemove();
        }
        if (context == null) {
            throw new FlowReplayException("\u5355\u4e2a\u7528\u4f8b\u56de\u653e\u4e0a\u4e0b\u6587\u4e22\u5931_traceId=" + trace.getTraceId());
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getErrorMsgType(), context.getErrorMsgDetail());
        }
        return ReplayTraceResult.successResult(trace, replayResultValue);
    }

    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

