/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
@ConditionalOnClass(value={Cache.class})
public class GuavaCacheMonitorConfiguration {
    private static final String path = System.getProperty("user.dir");
    private static final ConcurrentMap<String, Cache> allCacheMap = Maps.newConcurrentMap();
    private static final LocalPersistenceService persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(path, "/monitor")));
    private static final PersistentUserManagedCache<String, String> monitorCache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, String.class).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext("monitorCache", persistenceService)).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap(10L, (ResourceUnit)EntryUnit.ENTRIES).disk(10L, MemoryUnit.MB, true)).build(true);

    @Configuration
    public static class GuavaCacheVariables
    implements ApplicationContextAware {
        private ApplicationContext appContext;

        @Async
        @EventListener(value={MainContextRefreshedEvent.class})
        public void loadAllCacheBean() {
            String[] beans;
            for (String bean : beans = this.appContext.getBeanDefinitionNames()) {
                Field[] fields = bean.getClass().getDeclaredFields();
                if (fields.length == 0) continue;
                Object beanObj = this.appContext.getBean(bean);
                for (Field field : fields) {
                    if (!field.getType().isAssignableFrom(Cache.class)) continue;
                    field.setAccessible(true);
                    try {
                        allCacheMap.put(field.getName(), (Cache)field.get(beanObj));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.appContext = applicationContext;
        }
    }
}

