/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.FlowReplayTraceMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ReplayTraceContextMapHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ReplaySpringMvcFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FlowReplayTrace trace;
        HttpServletRequest req = (HttpServletRequest)request;
        String traceId = req.getHeader("Flow-Replay-Trace-Id");
        if (FlowReplayUtils.isReplayEnv() && StringUtils.isNotBlank((CharSequence)traceId) && (trace = FlowReplayTraceMapHolder.getAndRemove(traceId)) != null) {
            ReplayTraceContext.create(trace);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            ReplayTraceContext context = ReplayTraceContext.getAndRemove();
            if (context != null) {
                DBTimeProfile.setCurrentThreshold((int)1000000);
                ReplayTraceContextMapHolder.put(context);
            }
        }
    }

    public void destroy() {
    }
}

