/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.SummaryMetricFamily;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.agent.ByteBuddyAgent;

public class CacheMetricsCollector
extends Collector {
    protected final ConcurrentMap<String, Cache> children = new ConcurrentHashMap<String, Cache>();
    protected final ConcurrentMap<String, List<String>> labelsMap = new ConcurrentHashMap<String, List<String>>();

    public void addCache(String cacheName, Cache cache, String instance, String service) {
        this.children.put(cacheName, cache);
        this.labelsMap.put(cacheName, Arrays.asList(instance, service));
    }

    public Cache removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    public long getSize() {
        return this.children.size();
    }

    public List<Collector.MetricFamilySamples> collect() {
        Instrumentation instrumentation = ByteBuddyAgent.install();
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        ArrayList labelNames = Lists.newArrayList((Object[])new String[]{"cache"});
        labelNames.add("instance");
        labelNames.add("service");
        CounterMetricFamily cacheHitTotal = new CounterMetricFamily("guava_cache_hit_total", "Cache hit totals", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheHitTotal);
        CounterMetricFamily cacheMissTotal = new CounterMetricFamily("guava_cache_miss_total", "Cache miss totals", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheMissTotal);
        CounterMetricFamily cacheRequestsTotal = new CounterMetricFamily("guava_cache_requests_total", "Cache request totals, hits + misses", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheRequestsTotal);
        CounterMetricFamily cacheEvictionTotal = new CounterMetricFamily("guava_cache_eviction_total", "Cache eviction totals, doesn't include manually removed entries", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheEvictionTotal);
        CounterMetricFamily cacheLoadFailure = new CounterMetricFamily("guava_cache_load_failure_total", "Cache load failures", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadFailure);
        CounterMetricFamily cacheLoadTotal = new CounterMetricFamily("guava_cache_loads_total", "Cache loads: both success and failures", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadTotal);
        GaugeMetricFamily cacheSize = new GaugeMetricFamily("guava_cache_size", "Cache size", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheSize);
        GaugeMetricFamily cacheMemory = new GaugeMetricFamily("guava_cache_memory", "Cache Memory", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheMemory);
        SummaryMetricFamily cacheLoadSummary = new SummaryMetricFamily("guava_cache_load_duration_seconds", "Cache load duration: both success and failures", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadSummary);
        for (Map.Entry c : this.children.entrySet()) {
            ArrayList labelValues = Lists.newArrayList((Object[])new String[]{(String)c.getKey()});
            labelValues.addAll((Collection)this.labelsMap.get(c.getKey()));
            CacheStats stats = ((Cache)c.getValue()).stats();
            cacheHitTotal.addMetric((List)labelValues, (double)stats.hitCount());
            cacheMissTotal.addMetric((List)labelValues, (double)stats.missCount());
            cacheRequestsTotal.addMetric((List)labelValues, (double)stats.requestCount());
            cacheEvictionTotal.addMetric((List)labelValues, (double)stats.evictionCount());
            cacheSize.addMetric((List)labelValues, (double)((Cache)c.getValue()).size());
            cacheMemory.addMetric((List)labelValues, (double)instrumentation.getObjectSize(c.getValue()));
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.addMetric((List)labelValues, (double)stats.loadExceptionCount());
            cacheLoadTotal.addMetric((List)labelValues, (double)stats.loadCount());
            cacheLoadSummary.addMetric((List)labelValues, (double)stats.loadCount(), (double)stats.totalLoadTime() / 1.0E9);
        }
        return mfs;
    }
}

