/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMetricsCollector;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import io.prometheus.client.Collector;
import io.prometheus.client.exporter.PushGateway;
import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
@ConditionalOnClass(value={Cache.class})
public class GuavaCacheMonitorConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GuavaCacheMonitorConfiguration.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Value(value="${prometheus.pushgateway.address}")
    private String pushGatewayAddress;
    private final String path = System.getProperty("user.dir");
    private final ConcurrentMap<String, Cache> allCacheMap = Maps.newConcurrentMap();
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register();
    private final LocalPersistenceService persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(this.path, "/monitor")));
    private final PersistentUserManagedCache<String, String> monitorCache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, String.class).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext("monitorCache", this.persistenceService)).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap(10L, (ResourceUnit)EntryUnit.ENTRIES).disk(10L, MemoryUnit.MB, true)).build(true);
    private ApplicationContext appContext;
    private final String localIp = NetUtils.getLocalIp();
    private final String prometheusJobName = "gauva_cache_monitor";
    private ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);

    @Async
    @EventListener(value={MainContextRefreshedEvent.class})
    public void loadAllCacheBean() {
        String[] beans;
        for (String beanName : beans = this.appContext.getBeanDefinitionNames()) {
            Object beanObj = this.appContext.getBean(beanName);
            Field[] fields = beanObj.getClass().getDeclaredFields();
            if (fields.length == 0) continue;
            this.addCache(fields, beanName, beanObj);
        }
        this.pushRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCache(Field[] fields, String beanName, Object beanObj) {
        for (Field field : fields) {
            if (!Cache.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                String keyName = String.format("%s-%s", beanName, field.getName());
                Cache cache = (Cache)field.get(beanObj);
                this.allCacheMap.put(keyName, cache);
                this.cacheMetrics.addCache(keyName, cache, this.localIp, this.currentAppName);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private void pushRecord() {
        if (this.cacheMetrics.getSize() == 0L) {
            return;
        }
        PushGateway pushGateway = new PushGateway(this.pushGatewayAddress);
        this.scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                pushGateway.pushAdd((Collector)this.cacheMetrics, "gauva_cache_monitor");
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6307\u6807\u5230pushgateway\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }
}

