/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayMockSupport;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ReplayContextHolder {
    private static final List<String> DEFAULT_HOST_WHITELIST = Arrays.asList("127.0.0.1", "localhost");
    private static volatile boolean replaying = false;
    private static volatile ReplayContext replayContext;
    private static volatile List<String> ipWhitelist;
    private static volatile long mockSysTime;
    private static volatile long recordStartTime;

    private ReplayContextHolder() {
    }

    public static boolean isReplaying() {
        return replaying && replayContext != null;
    }

    public static synchronized void start(ReplayConfigDto replayConfig) {
        if (replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u5f00\u59cb_\u8bf7\u52ff\u91cd\u590d\u5f00\u59cb");
        }
        replaying = true;
        replayContext = new ReplayContext(replayConfig);
        ipWhitelist = replayConfig.getIpWhitelist();
        ipWhitelist.addAll(DEFAULT_HOST_WHITELIST);
        replayContext.start();
        recordStartTime = replayConfig.getStartTime();
        mockSysTime = replayConfig.getStartTime();
        ReplayMockSupport.setOffsetMillis(mockSysTime - replayContext.getStartTime());
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayStartEvent());
    }

    public static boolean canHostPass(String host) {
        if (CollectionUtils.isEmpty(ipWhitelist)) {
            return true;
        }
        return ipWhitelist.contains(host);
    }

    public static long calculateTraceTimestamp(short secondsAfterStart) {
        return recordStartTime + (long)(secondsAfterStart * 1000);
    }

    public static boolean isMockSysTimeValid(long traceTimestamp) {
        return traceTimestamp - mockSysTime < 60000L;
    }

    public static synchronized void setMockSysTime(long traceTimestamp) {
        if (ReplayContextHolder.isMockSysTimeValid(traceTimestamp)) {
            return;
        }
        mockSysTime = traceTimestamp;
        ReplayMockSupport.setOffsetMillis(mockSysTime - replayContext.getStartTime());
    }

    public static synchronized void end() {
        if (!replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u7ed3\u675f_\u8bf7\u52ff\u91cd\u590d\u7ed3\u675f");
        }
        replaying = false;
        ReplayMockSupport.setOffsetMillis(0L);
        replayContext.end();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayEndEvent());
    }

    public static void forceEnd() {
        replayContext.tracesLoadFinish();
        replayContext.replayersDone();
        ReplayContextHolder.end();
    }

    public static ReplayContext getReplayContext() {
        return replayContext;
    }
}

