/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast;

import ch.qos.logback.classic.Level;
import cn.com.duiba.boot.utils.JarVersionUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaClientUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaOneDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final Logger log = LoggerFactory.getLogger(EurekaOneDiscoveryStrategy.class);
    protected static final String HAZELCAST_PORT = "hazelcast.port";
    @VisibleForTesting
    static final int NUM_RETRIES = 5;
    private static final int VERIFICATION_WAIT_TIMEOUT = 1;
    private static final int DISCOVERY_RETRY_TIMEOUT = 1;
    private final EurekaClient eurekaClient;
    private final ApplicationInfoManager applicationInfoManager;

    private EurekaOneDiscoveryStrategy(EurekaOneDiscoveryStrategyBuilder builder) {
        super(builder.logger, builder.properties);
        this.applicationInfoManager = builder.applicationInfoManager;
        this.eurekaClient = builder.eurekaClient;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        if (FlowReplayUtils.isReplayEnv()) {
            log.info("\u68c0\u6d4b\u5230\u5f53\u524d\u5b9e\u4f8b\u662f\u6d41\u91cf\u56de\u653e\u5b9e\u4f8b\uff0c\u4e0d\u4f1a\u52a0\u5165hazelcast\u96c6\u7fa4!");
            return nodes;
        }
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        Application application = null;
        for (int i = 0; i < 5; ++i) {
            EurekaClientUtils.refreshRegistry(this.eurekaClient);
            application = this.eurekaClient.getApplication(applicationName);
            if (application != null) break;
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
        if (application != null) {
            List instances = application.getInstancesAsIsFromEureka();
            for (InstanceInfo instance : instances) {
                String duibaBootVersion;
                Map metadata;
                String portStr;
                int port;
                InetAddress address;
                if (instance.getStatus() != InstanceInfo.InstanceStatus.UP && instance.getStatus() != InstanceInfo.InstanceStatus.STARTING || null == (address = this.mapAddress(instance)) || (port = NumberUtils.parseInt((String)(portStr = (String)(metadata = instance.getMetadata()).get(HAZELCAST_PORT)), (int)-1)) == -1 || !JarVersionUtils.isJarVersionEqualOrGreaterThan((String)(duibaBootVersion = (String)metadata.get("duibaBootVersion")), (String)"1.2.248")) continue;
                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address, port), metadata));
            }
        }
        log.info("hazelcast found nodes {}", nodes.stream().map(discoveryNode -> discoveryNode.getPrivateAddress()).collect(Collectors.toList()));
        return nodes;
    }

    public void start() {
        if (FlowReplayUtils.isReplayEnv()) {
            return;
        }
        this.verifyEurekaRegistration();
    }

    public void destroy() {
    }

    private InetAddress mapAddress(InstanceInfo instance) {
        try {
            return InetAddress.getByName(instance.getIPAddr());
        }
        catch (UnknownHostException e) {
            this.getLogger().warning("InstanceInfo '" + instance + "' could not be resolved");
            return null;
        }
    }

    @VisibleForTesting
    void verifyEurekaRegistration() {
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        while (true) {
            block6: {
                try {
                    this.getLogger().info("Waiting for registration with Eureka...");
                    EurekaClientUtils.refreshRegistry(this.eurekaClient);
                    Application application = this.eurekaClient.getApplication(applicationName);
                    if (application != null) {
                        break;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof Error)) break block6;
                    throw (Error)t;
                }
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        ((ch.qos.logback.classic.Logger)log).setLevel(Level.INFO);
    }

    static final class EurekaOneDiscoveryStrategyBuilder {
        private EurekaClient eurekaClient;
        private ApplicationInfoManager applicationInfoManager;
        private DiscoveryNode discoveryNode;
        private ILogger logger = new NoLogFactory().getLogger(EurekaOneDiscoveryStrategy.class.getName());
        private Map<String, Comparable> properties = Collections.emptyMap();

        EurekaOneDiscoveryStrategyBuilder() {
        }

        EurekaOneDiscoveryStrategyBuilder setEurekaClient(EurekaClient eurekaClient) {
            this.eurekaClient = eurekaClient;
            if (eurekaClient != null) {
                this.applicationInfoManager = eurekaClient.getApplicationInfoManager();
            }
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setDiscoveryNode(DiscoveryNode discoveryNode) {
            this.discoveryNode = discoveryNode;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setILogger(ILogger logger) {
            this.logger = logger;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setProperties(Map<String, Comparable> properties) {
            this.properties = properties;
            return this;
        }

        EurekaOneDiscoveryStrategy build() {
            return new EurekaOneDiscoveryStrategy(this);
        }
    }
}

