/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheMonitorComponet
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorComponet.class);
    private static EtcdKVClientDelegate etcdKVClientDelegate;
    private static final ConcurrentMap<Object, String> allCacheMap;
    private static final ConcurrentMap<Integer, Object> cacheBuilderMap;
    private static final Queue<CacheChangeRecord> recordQueue;
    private static final LocalPersistenceService persistenceService;
    private static final PersistentUserManagedCache<String, CacheChangeRecord> monitorCache;
    private static ScheduledExecutorService scheduledThreadPool;

    static void saveCache(Object key, String value) {
        allCacheMap.put(key, value);
    }

    public static Set<String> getAllCache() {
        HashSet names = Sets.newHashSet();
        for (Map.Entry entry : allCacheMap.entrySet()) {
            names.add(entry.getValue());
        }
        return names;
    }

    static Object getCacheValueByKey(String cacheName, String key) {
        Cache cache;
        Object cacheObj = null;
        for (Map.Entry entry : allCacheMap.entrySet()) {
            if (!((String)entry.getValue()).equals(cacheName)) continue;
            cacheObj = entry.getKey();
            break;
        }
        if (cacheObj == null) {
            return null;
        }
        if (cacheObj instanceof Cache) {
            cache = cacheObj;
            return cache.getIfPresent((Object)key);
        }
        if (cacheObj instanceof com.github.benmanes.caffeine.cache.Cache) {
            cache = cacheObj;
            return cache.getIfPresent((Object)key);
        }
        return null;
    }

    static void setBuilderCache(Integer hashcode, Object value) {
        cacheBuilderMap.put(hashcode, value);
    }

    static void addRecord(CacheChangeRecord record) {
        if (etcdKVClientDelegate == null) {
            log.warn("has no bean etcdKVClientDelegate");
            return;
        }
        Object cache = cacheBuilderMap.get(record.getBuilderHashcode());
        if (cache == null) {
            return;
        }
        String cacheName = (String)allCacheMap.get(cache);
        record.setCacheName(cacheName);
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            return;
        }
        String path = String.format("/cache/monitor/name/%s", cacheName);
        String conifg = etcdKVClientDelegate.get(path);
        if ("true".equals(conifg)) {
            recordQueue.offer(record);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        etcdKVClientDelegate = (EtcdKVClientDelegate)applicationContext.getBean(EtcdKVClientDelegate.class);
    }

    static {
        allCacheMap = Maps.newConcurrentMap();
        cacheBuilderMap = Maps.newConcurrentMap();
        recordQueue = new ConcurrentLinkedQueue<CacheChangeRecord>();
        persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(System.getProperty("user.dir"), "/monitor")));
        monitorCache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, CacheChangeRecord.class).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext("monitorCache", persistenceService)).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap(10L, (ResourceUnit)EntryUnit.ENTRIES).disk(10L, MemoryUnit.MB, true)).build(true);
        scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            if (recordQueue.size() == 0) {
                return;
            }
            int len = recordQueue.size();
            for (int i = 0; i < len; ++i) {
                CacheChangeRecord oldRecord;
                CacheChangeRecord newRecord = recordQueue.poll();
                if (newRecord == null || StringUtils.isBlank((CharSequence)newRecord.getCacheName()) || newRecord.equals(oldRecord = (CacheChangeRecord)monitorCache.get((Object)newRecord.getCacheName()))) continue;
                monitorCache.put((Object)newRecord.getCacheName(), (Object)newRecord);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }
}

