/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483647)
public class FeatureFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath((HttpServletRequest)request);
        if (requestPath.equals("/_disableFeature")) {
            this.enableFeature(request, response, false);
        } else if (requestPath.equals("/_enableFeature")) {
            this.enableFeature(request, response, true);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void enableFeature(HttpServletRequest request, HttpServletResponse response, boolean isEnable) throws IOException {
        if (!HttpRequestUtils.isLocalRequest(request)) {
            response.getWriter().write("NO PERMISSION");
            return;
        }
        String type = request.getParameter("type");
        if (StringUtils.isBlank((String)type)) {
            response.getWriter().write("ERROR");
            return;
        }
        if (type.equals("cat") && CatUtils.isCatClassExists()) {
            if (isEnable) {
                CatInstance.enable();
            } else {
                CatInstance.disable();
            }
        } else {
            response.getWriter().write("ERROR");
            return;
        }
        response.getWriter().write("OK");
    }

    public void destroy() {
    }
}

