/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.elasticsearch;

import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.GetQuery;

public class CustomElasticsearchTemplate
extends ElasticsearchTemplate {
    private Client client;
    private String searchTimeout;

    public CustomElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, String searchTimeout) {
        super(client, elasticsearchConverter);
        this.client = client;
        this.searchTimeout = searchTimeout;
    }

    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        if (this.searchTimeout == null) {
            return (T)super.queryForObject(query, clazz, mapper);
        }
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetResponse response = (GetResponse)this.client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute().actionGet(this.searchTimeout);
        return (T)mapper.mapResult(response, clazz);
    }
}

