/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.RemovalCauseUtil;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalListeners;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBuilderInterceptor
implements StaticMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CacheBuilderInterceptor.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
    }

    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        if (!"newBuilder".equals(method.getName())) {
            return ret;
        }
        try {
            if (ret instanceof CacheBuilder) {
                CacheBuilder cacheBuilder = (CacheBuilder)ret;
                RemovalListener removalListener = RemovalListeners.asynchronous(notification -> {
                    if (notification.getKey() == null) {
                        return;
                    }
                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(notification.getKey());
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(notification.getCause().name()));
                    changeRecord.setValue(JSON.toJSONString((Object)notification.getValue()));
                    changeRecord.setBuilderHashcode(cacheBuilder.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);
                }, (Executor)this.executorService);
                return cacheBuilder.recordStats().removalListener(removalListener);
            }
            if (ret instanceof Caffeine) {
                Caffeine caffeine = (Caffeine)ret;
                return caffeine.recordStats().removalListener((key, value, cause) -> {
                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(key);
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(cause.name()));
                    changeRecord.setValue(JSON.toJSONString((Object)value));
                    changeRecord.setBuilderHashcode(caffeine.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);
                });
            }
        }
        catch (Exception e) {
            log.error("cacheBuilder afterMethod excetion", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }
}

