/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMetricsCollector;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorFilter;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.cache.CacheBuilder;
import io.prometheus.client.Collector;
import io.prometheus.client.exporter.PushGateway;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAsync
@ConditionalOnClass(value={CacheBuilder.class, Caffeine.class})
@AutoConfigureAfter(value={EtcdAutoConfiguration.class})
public class CacheMonitorConfiguration
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorConfiguration.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Value(value="${prometheus.pushgateway.address}")
    private String pushGatewayAddress;
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register();
    private ApplicationContext appContext;
    private final String localIp = NetUtils.getLocalIp();
    private final String prometheusJobName = "cache_monitor";
    private ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
    @Resource
    private EtcdKVClientDelegate etcdKVClientDelegate;

    @Async
    @EventListener(value={MainContextRefreshedEvent.class})
    public void loadAllCacheBean() {
        String[] beans = this.appContext.getBeanDefinitionNames();
        String curEnv = SpringEnvironmentUtils.getCurrentEnv();
        for (String beanName : beans) {
            Object beanObj = this.appContext.getBean(beanName);
            Field[] fields = beanObj.getClass().getDeclaredFields();
            if (fields.length == 0) continue;
            this.addCache(fields, beanName, beanObj, curEnv);
        }
        this.pushRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCache(Field[] fields, String beanName, Object beanObj, String curEnv) {
        for (Field field : fields) {
            boolean isGuava = com.google.common.cache.Cache.class.isAssignableFrom(field.getType());
            boolean isCaffeine = Cache.class.isAssignableFrom(field.getType());
            if (!isGuava && !isCaffeine) continue;
            field.setAccessible(true);
            String keyName = String.format("%s-%s", beanName, field.getName());
            try {
                Object cache = null;
                if (isGuava) {
                    cache = field.get(beanObj);
                    CacheMonitorManager.saveCache(cache, keyName);
                }
                if (isCaffeine) {
                    cache = field.get(beanObj);
                    CacheMonitorManager.saveCache(cache, keyName);
                }
                this.cacheMetrics.addCache(keyName, cache, this.localIp, this.currentAppName, curEnv);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private void pushRecord() {
        if (this.cacheMetrics.getSize() == 0L) {
            return;
        }
        PushGateway pushGateway = new PushGateway(this.pushGatewayAddress);
        this.scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                pushGateway.pushAdd((Collector)this.cacheMetrics, "cache_monitor");
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6307\u6807\u5230pushgateway\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void afterPropertiesSet() {
        CacheMonitorManager.init(this.etcdKVClientDelegate, this.currentAppName);
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnWebApplication
    public static class CacheMonitorFilterConfiguration {
        @Bean
        public FilterRegistrationBean cacheMonitorFilterConfiguration() {
            CacheMonitorFilter filter2 = new CacheMonitorFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/monitor/cache/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483647);
            return registrationBean;
        }
    }
}

