/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class CacheMonitorFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath((HttpServletRequest)request);
        if (requestPath.equals("/monitor/cache/all")) {
            Set<String> allCaches = CacheMonitorManager.getAllCache();
            response.getWriter().write(JSON.toJSONString(allCaches));
        } else if (requestPath.equals("/monitor/cache/query")) {
            response.getWriter().write(JSON.toJSONString((Object)this.doQuery(servletRequest)));
        } else if (requestPath.equals("/monitor/cache/record")) {
            response.getWriter().write(JSON.toJSONString((Object)this.doRecord(servletRequest)));
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    private String doQuery(ServletRequest servletRequest) {
        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)cacheName)) {
            return null;
        }
        Object value = CacheMonitorManager.getCacheValueByKey(cacheName, key);
        return JSON.toJSONString((Object)value);
    }

    private String doRecord(ServletRequest servletRequest) {
        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)cacheName)) {
            return null;
        }
        ArrayList value = CacheMonitorManager.getRecord(cacheName, key);
        return JSON.toJSONString((Object)value);
    }

    public void destroy() {
    }
}

