/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorManager.class);
    private static EtcdKVClientDelegate etcdKVClientDelegate;
    private static final String localIp;
    private static String currentAppName;
    private static final ConcurrentMap<Object, String> allCacheMap;
    private static final ConcurrentMap<Integer, Object> cacheBuilderMap;
    private static final Queue<CacheChangeRecord> recordQueue;
    private static final LocalPersistenceService persistenceService;
    private static final PersistentUserManagedCache<String, ArrayList> monitorCache;
    private static ScheduledExecutorService scheduledThreadPool;

    CacheMonitorManager() {
    }

    static void saveCache(Object key, String value) {
        allCacheMap.put(key, value);
    }

    static Set<String> getAllCache() {
        HashSet names = Sets.newHashSet();
        for (Map.Entry entry : allCacheMap.entrySet()) {
            names.add(entry.getValue());
        }
        return names;
    }

    static Object getCacheValueByKey(String cacheName, String key) {
        Iterator iterator;
        Cache cache;
        Object cacheObj = null;
        for (Map.Entry entry : allCacheMap.entrySet()) {
            if (!((String)entry.getValue()).equals(cacheName)) continue;
            cacheObj = entry.getKey();
            break;
        }
        if (cacheObj == null) {
            return null;
        }
        if (cacheObj instanceof Cache) {
            cache = cacheObj;
            iterator = cache.asMap().keySet().iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Class<?> aClass = iterator.next().getClass();
            return cache.getIfPresent(JSON.parseObject((String)key, aClass));
        }
        if (cacheObj instanceof com.github.benmanes.caffeine.cache.Cache) {
            cache = cacheObj;
            iterator = cache.asMap().keySet().iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Class<?> aClass = iterator.next().getClass();
            return cache.getIfPresent(JSON.parseObject((String)key, aClass));
        }
        return null;
    }

    static ArrayList getRecord(String cacheName, String key) {
        if (StringUtils.isBlank((CharSequence)cacheName) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String cacheKey = String.format("%s-%s", cacheName, key);
        return (ArrayList)monitorCache.get((Object)cacheKey);
    }

    static void setBuilderCache(Integer hashcode, Object value) {
        cacheBuilderMap.put(hashcode, value);
    }

    static void addRecord(CacheChangeRecord record) {
        if (etcdKVClientDelegate == null) {
            log.warn("has no bean etcdKVClientDelegate");
            return;
        }
        if (StringUtils.isBlank((CharSequence)currentAppName)) {
            log.warn("has no currentAppName");
            return;
        }
        Object cache = cacheBuilderMap.get(record.getBuilderHashcode());
        if (cache == null) {
            return;
        }
        String cacheName = (String)allCacheMap.get(cache);
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            return;
        }
        String path = String.format("/cache/monitor/%s/%s/%s", currentAppName, localIp, cacheName);
        String conifg = etcdKVClientDelegate.get(path);
        if ("true".equals(conifg)) {
            record.setCacheName(cacheName);
            recordQueue.offer(record);
        }
    }

    static void init(EtcdKVClientDelegate bean, String appName) {
        if (etcdKVClientDelegate == null) {
            etcdKVClientDelegate = bean;
        }
        if (appName != null) {
            currentAppName = appName;
        }
    }

    static {
        localIp = NetUtils.getLocalIp();
        allCacheMap = Maps.newConcurrentMap();
        cacheBuilderMap = Maps.newConcurrentMap();
        recordQueue = new ConcurrentLinkedQueue<CacheChangeRecord>();
        persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(System.getProperty("user.home"), "/monitor")));
        monitorCache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, ArrayList.class).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext("monitorCache", persistenceService)).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap(10L, (ResourceUnit)EntryUnit.ENTRIES).disk(10L, MemoryUnit.MB, true)).build(true);
        scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            if (recordQueue.size() == 0) {
                return;
            }
            int len = recordQueue.size();
            for (int i = 0; i < len; ++i) {
                CacheChangeRecord newRecord = recordQueue.poll();
                if (newRecord == null || StringUtils.isBlank((CharSequence)newRecord.getCacheName())) continue;
                String key = String.format("%s-%s", newRecord.getCacheName(), String.valueOf(newRecord.getKey()));
                ArrayList oldRecords = (ArrayList)monitorCache.get((Object)key);
                if (CollectionUtils.isEmpty((Collection)oldRecords)) {
                    oldRecords = Lists.newArrayList();
                    newRecord.buildSerializableObj();
                    oldRecords.add(newRecord);
                    monitorCache.put((Object)key, (Object)oldRecords);
                    continue;
                }
                CacheChangeRecord lastRecord = (CacheChangeRecord)oldRecords.get(oldRecords.size() - 1);
                if (newRecord.equals(lastRecord)) continue;
                newRecord.buildSerializableObj();
                oldRecords.add(newRecord);
                monitorCache.put((Object)key, (Object)oldRecords);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }
}

