/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;

public class XmlDefensivePolicy
implements DefensivePolicy {
    private Pattern pattern = Pattern.compile("DOCTYPE|SYSTEM|ENTITY|PUBLIC");

    @Override
    public Set<MediaType> getMediaTypes() {
        return Sets.newHashSet((Object[])new MediaType[]{MediaType.APPLICATION_XML, MediaType.TEXT_XML});
    }

    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        return new BodyReaderHttpServletRequestWrapper(request);
    }

    @Override
    public void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException {
        BodyReaderHttpServletRequestWrapper wrapper = (BodyReaderHttpServletRequestWrapper)request;
        String body = wrapper.getBody();
        Matcher matcher = this.pattern.matcher(body);
        if (matcher.find()) {
            throw new DuibaSecurityException("XXE\u98ce\u9669\u544a\u8b66\uff01");
        }
    }
}

