package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.client.*;

import java.net.URI;

public class SsreAsyncRestTemplateWrapper extends AsyncRestTemplate implements ClientWrapper {


    @Override
    public boolean trySetClient(Object client) {
        if(client==null || !AsyncRestTemplate.class.isAssignableFrom(client.getClass())){
            return false;
        }
        BeanUtils.copyProperties(client,this);
        return true;
    }

    @Override
    public Class acceptableClass() {
        return AsyncRestOperations.class;
    }


    @Override
    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        try{
            SsreUtils.checkSsre(url);
        }catch (SsreRiskException e){
            SettableListenableFuture<T> future = new SettableListenableFuture<>();
            future.setException(e);
            return future;
        }
        return super.doExecute(url, method, requestCallback, responseExtractor);
    }
}
