/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dbexec;

public enum ExecutableCommand {
    JSTAT_GCUTIL("jstat_gcutil", "jstat -gcutil ${vmid} 1000 10"),
    JSTAT_GC("jstat_gc", "jstat -gc ${vmid} 1000 10"),
    JSTAT_CLASS("jstat_class", "jstat -class ${vmid}"),
    JSTAT_COMPILER("jstat_compiler", "jstat -compiler ${vmid}"),
    JSTAT_GCCAPACITY("jstat_gccapacity", "jstat -gccapacity ${vmid} 1000 10"),
    JSTAT_GCCAUSE("jstat_gccause", "jstat -gccause ${vmid} 1000 10"),
    JSTAT_GCNEW("jstat_gcnew", "jstat -gcnew ${vmid} 1000 10"),
    JSTAT_GCNEWCAPACITY("jstat_gcnewcapacity", "jstat -gcnewcapacity ${vmid} 1000 10"),
    JSTAT_GCOLD("jstat_gcold", "jstat -gcold ${vmid} 1000 10"),
    JSTAT_GCOLDCAPACITY("jstat_gcoldcapacity", "jstat -gcoldcapacity ${vmid} 1000 10"),
    JSTAT_GCMETACAPACITY("jstat_gcmetacapacity", "jstat -gcmetacapacity ${vmid} 1000 10"),
    JSTAT_PRINTCOMPILATION("jstat_printcompilation", "jstat -printcompilation ${vmid} 1000 10"),
    JMAP_HISTO("jmap_histo", "jmap -histo ${vmid}");

    private String commandKey;
    private String command;

    private ExecutableCommand(String commandKey, String command) {
        this.commandKey = commandKey;
        this.command = command;
    }

    public static ExecutableCommand get(String commandKey) {
        for (ExecutableCommand item : ExecutableCommand.values()) {
            if (!item.getCommandKey().equals(commandKey)) continue;
            return item;
        }
        return null;
    }

    public static boolean contains(String commandKey) {
        return ExecutableCommand.get(commandKey) != null;
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public String getCommand() {
        return this.command;
    }
}

