package cn.com.duibaboot.ext.autoconfigure.gclog;

import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.io.*;

/**
 * 下载gclog的端点
 * Created by guoyanfei .
 */
public class GclogDownloadMvcEndpoint extends AbstractNamedMvcEndpoint {

    public GclogDownloadMvcEndpoint() {
        super("gclogDownload","/gclogDownload",true);
    }

    @RequestMapping(method = RequestMethod.GET)
    public void invoke(@RequestParam String path, HttpServletResponse response) throws IOException {
        if (!path.startsWith(GclogEndpoint.GCLOG_PATH)) {
            throw new UnsupportedOperationException("不支持的操作");
        }
        String pathFileName = path.substring(GclogEndpoint.GCLOG_PATH.length() + 1);
        if (pathFileName.contains("/") || pathFileName.contains("\\")) {
            throw new UnsupportedOperationException("不支持的操作");
        }

        File file = new File(path);

        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
        response.setContentLength((int) file.length());

        byte[] buffer = new byte[4096];
        try(
            BufferedOutputStream output = new BufferedOutputStream(response.getOutputStream());
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file))
        ) {
            int n = -1;
            while ((n = input.read(buffer, 0, 4096)) > -1) {
                output.write(buffer, 0, n);
            }
            output.flush();
            response.flushBuffer();
        }
    }

}
