package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 加入AOP，压测时ons消息添加压测标识
 */
@Aspect
public class OnsPerfAspect {

    //如果perfTestFootMarker为null，表示没有引入spring-boot-starter-perftest压测包
    @Autowired(required = false)
    private PerfTestFootMarker perfTestFootMarker;

    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);

    @Around("execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object onsSendJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo("onsProducer");
            Object[] args = joinPoint.getArgs();
            if (methodName.startsWith("send")) {
                if (args[0] instanceof Message) {
                    Message rawMsg = (Message) args[0];
                    rawMsg.putUserProperties("perfTest", "true");
                    String sceneId = InternalPerfTestContext.getCurrentSceneId();
                    if (StringUtils.isNotBlank(sceneId)) {
                        rawMsg.putUserProperties(PerfTestUtils.PERF_TEST_SCENE_ID_KEY, sceneId);

                        boolean isTestCluster = InternalPerfTestContext.isTestCluster();
                        rawMsg.putUserProperties(PerfTestUtils.PERF_TEST_CLUSTER, String.valueOf(isTestCluster));
                    }
                    return joinPoint.proceed(args);
                }
            }
        }
        return joinPoint.proceed();
    }

    @Around("execution(* com.aliyun.openservices.ons.api.MessageListener+.*(..))")
    public Object onsConsumeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (methodName.equals("consume")) {
            Object[] args = joinPoint.getArgs();
            if (args[0] instanceof Message) {
                Message rawMsg = (Message) args[0];
                if ("true".equals(rawMsg.getUserProperties("perfTest"))) {
                    //perfTestFootMarker为null表示当前项目没有接入压测
                    // 如果没有接入压测则不应该消费压测消息，直接返回消费成功，丢弃该消息
                    if(perfTestFootMarker == null){
                        return Action.CommitMessage;
                    }

                    String perfTestSceneId = rawMsg.getUserProperties(PerfTestUtils.PERF_TEST_SCENE_ID_KEY);
                    boolean isTestCluster = Boolean.valueOf(rawMsg.getUserProperties(PerfTestUtils.PERF_TEST_CLUSTER));
                    InternalPerfTestContext.markAsPerfTest(perfTestSceneId, isTestCluster);
                    perfTestFootMarker.markApp();
                    PerfTestContext.debugInfo("onsConsumer");
                    try {
                        return joinPoint.proceed();
                    }finally {
                        InternalPerfTestContext.markAsNormal();
                    }
                }
            }
        }
        return joinPoint.proceed();
    }
}
