package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import org.springframework.http.MediaType;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 1.防止XXE攻击
 */
public class XmlDefensivePolicy implements DefensivePolicy {

    private Pattern pattern = Pattern.compile("DOCTYPE|SYSTEM|ENTITY|PUBLIC");

    @Override
    public Set<MediaType> getMediaTypes() {
        return Sets.newHashSet(MediaType.APPLICATION_XML,MediaType.TEXT_XML);
    }


    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        return new BodyReaderHttpServletRequestWrapper(request);//解决请求只能获取一次的问题;
    }

    @Override
    public void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException {
        BodyReaderHttpServletRequestWrapper wrapper = (BodyReaderHttpServletRequestWrapper) request;
        String body = wrapper.getBody();
        Matcher matcher = pattern.matcher(body);
        if(matcher.find()){
            throw new DuibaSecurityException("XXE风险告警！");
        }

    }

}
