/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.util.EntityUtils;

public class HttpClientFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = -7977781583338574639L;
    private String method;
    private String url;
    private Map<String, String> requestHeaders;
    private Map<String, List<String>> requestParameters;
    private byte[] requestBody;
    private Map<String, String> responseHeaders;
    private String protocol;
    private int major;
    private int minor;
    private int statusCode;
    private String reasonPhrase;
    private byte[] responseBody;

    @Override
    public SpanType getSpanType() {
        return SpanType.HTTP_CLIENT;
    }

    public static HttpClientFlowReplaySpan createSpan(HttpRequestWrapper httpRequestWrapper, CloseableHttpResponse response) throws IOException {
        HttpClientFlowReplaySpan span = new HttpClientFlowReplaySpan();
        URI uri = httpRequestWrapper.getURI();
        span.setSpanId(UUIDUtils.createUUID());
        span.method = httpRequestWrapper.getMethod();
        span.url = HttpClientFlowReplaySpan.parseUrl(uri);
        span.requestHeaders = HttpClientFlowReplaySpan.parseRequestHeaders(httpRequestWrapper);
        span.requestParameters = HttpClientFlowReplaySpan.parseRequestParameters(uri);
        span.requestBody = HttpClientFlowReplaySpan.parseRequestBody(httpRequestWrapper);
        StatusLine statusLine = response.getStatusLine();
        ProtocolVersion protocolVersion = statusLine.getProtocolVersion();
        span.responseHeaders = HttpClientFlowReplaySpan.parseResponseHeaders(response.getAllHeaders());
        span.protocol = protocolVersion.getProtocol();
        span.major = protocolVersion.getMajor();
        span.minor = protocolVersion.getMinor();
        span.statusCode = statusLine.getStatusCode();
        span.reasonPhrase = statusLine.getReasonPhrase();
        span.responseBody = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        return span;
    }

    public static Map<String, String> parseResponseHeaders(Header[] allHeaders) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        if (allHeaders != null && allHeaders.length > 0) {
            for (Header h : allHeaders) {
                headers.put(h.getName(), h.getValue());
            }
        }
        return headers;
    }

    public static Map<String, String> parseRequestHeaders(HttpRequestWrapper httpRequestWrapper) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Header[] headergroup = httpRequestWrapper.getAllHeaders();
        if (headergroup != null && headergroup.length > 0) {
            for (Header h : headergroup) {
                headers.put(h.getName(), h.getValue());
            }
        }
        return headers;
    }

    public static byte[] parseRequestBody(HttpRequestWrapper httpRequestWrapper) throws IOException {
        byte[] requestBody = null;
        HttpRequest httpRequest = httpRequestWrapper.getOriginal();
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
            requestBody = EntityUtils.toByteArray((HttpEntity)entityEnclosingRequest.getEntity());
        }
        return requestBody;
    }

    public static String parseUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriStr = uri.toString();
        if (uriStr.contains("?")) {
            uriStr = uriStr.substring(0, uriStr.indexOf("?"));
        }
        if (!uriStr.endsWith("/")) {
            uriStr = uriStr + "/";
        }
        return uriStr;
    }

    public static Map<String, List<String>> parseRequestParameters(URI uri) throws UnsupportedEncodingException {
        HashMap<String, List<String>> parameter = new HashMap<String, List<String>>();
        if (uri == null) {
            return parameter;
        }
        String query = uri.getQuery();
        if (StringUtils.isBlank((CharSequence)query)) {
            return parameter;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }
            List values = parameter.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return parameter;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> getRequestParameters() {
        return this.requestParameters;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }
}

