/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordContext {
    private static final Logger log = LoggerFactory.getLogger(RecordContext.class);
    private static final int TRACE_QUEUE_SIZE = 500;
    private final Long usecaseSetId;
    private final Integer maxMinutes;
    private volatile Long startTime;
    private volatile Long endTime;
    private final Integer maxFileSize;
    private long currentFileSize;
    private RandomAccessFile raf;
    private LinkedBlockingQueue<FlowReplayTrace> traceQueue = new LinkedBlockingQueue(500);
    private volatile boolean recordFinished = false;
    private volatile RecordResult recordResult;

    public RecordContext(RecordConfigDto recordConfig) {
        if (recordConfig == null || !recordConfig.isLegal()) {
            throw new FlowReplayException("\u5f55\u5236\u914d\u7f6e\u4e3a\u7a7aor\u5f55\u5236\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.usecaseSetId = recordConfig.getUsecaseSetId();
        this.maxMinutes = recordConfig.getMaxMinutes();
        this.startTime = null;
        this.endTime = null;
        this.maxFileSize = recordConfig.getMaxFileSize();
        this.currentFileSize = 0L;
        this.recordResult = null;
    }

    public boolean isTimeToEnd() {
        if (this.startTime == null || this.maxMinutes == null) {
            log.error("\u5f55\u5236\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7aor\u6700\u5927\u5f55\u5236\u5206\u949f\u6570\u4e3a\u7a7a_\u8fd4\u56de\u9700\u8981\u7ed3\u675f\u5f55\u5236");
            return true;
        }
        long expectEndTime = this.startTime + (long)(this.maxMinutes * 60 * 1000);
        return expectEndTime < System.currentTimeMillis();
    }

    public boolean isFileSizeToEnd() {
        if (this.maxFileSize == null) {
            log.error("\u5f55\u5236\u6587\u4ef6\u7684\u6700\u5927\u9650\u5236\u4e3a\u7a7a_\u8fd4\u56de\u9700\u8981\u7ed3\u675f\u5f55\u5236");
            return true;
        }
        int expectFileSize = this.maxFileSize * 1024 * 1024;
        return (long)expectFileSize < this.currentFileSize;
    }

    private synchronized void initRecordFile() {
        File file = new File("/data/flowreplay/flow_record");
        if (file.exists()) {
            return;
        }
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.writeInt(1);
            this.raf.writeInt(0);
        }
        catch (IOException e) {
            log.error("\u521d\u59cb\u5316RandomAccessFile\u5f02\u5e38", (Throwable)e);
            throw new FlowReplayException("\u521d\u59cb\u5316RandomAccessFile\u5f02\u5e38");
        }
    }

    private synchronized void closeFile() {
        if (this.raf != null) {
            IOUtils.closeQuietly((Closeable)this.raf);
        }
        this.raf = null;
    }

    public synchronized void writeTrace(FlowReplayTrace trace) throws IOException {
        if (this.raf == null) {
            return;
        }
        if (trace == null) {
            return;
        }
        byte[] traceBytes = Hessian2Serializer.serialize(trace);
        this.raf.writeInt(traceBytes.length);
        this.raf.write(traceBytes);
        this.currentFileSize = this.raf.getFilePointer();
    }

    public void start() {
        this.initRecordFile();
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.closeFile();
        this.endTime = System.currentTimeMillis();
    }

    public void setRecordResult(RecordResult recordResult) {
        this.recordResult = recordResult;
    }

    public Long getUsecaseSetId() {
        return this.usecaseSetId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public long getCurrentFileSize() {
        return this.currentFileSize;
    }

    public RecordResult getRecordResult() {
        return this.recordResult;
    }

    public void offerTrace(FlowReplayTrace trace) {
        this.traceQueue.offer(trace);
    }

    public FlowReplayTrace pollTrace() throws InterruptedException {
        return this.traceQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isTraceQueueEmpty() {
        return this.traceQueue.size() < 1;
    }

    public void recordFinished() {
        this.recordFinished = true;
    }

    public boolean isRecordFinished() {
        return this.recordFinished;
    }
}

