/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.BufferedHttpResponseWapper;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.HttpClientFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordHttpClientMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordHttpClientMethodInterceptor.class);

    private boolean canRecord(Method method, Object[] allArguments) {
        if (!"execute".equals(method.getName())) {
            return false;
        }
        return FlowReplayTrace.isTraced();
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return;
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return;
        }
        IgnoreSubInvokesContext.instMark(obj, method, allArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return ret;
        }
        if (!IgnoreSubInvokesContext.isInstMarked(obj, method, allArguments)) {
            return ret;
        }
        try {
            HttpRequestWrapper httpRequestWrapper = (HttpRequestWrapper)allArguments[1];
            CloseableHttpResponse response = (CloseableHttpResponse)ret;
            BufferedHttpResponseWapper responseWapper = new BufferedHttpResponseWapper(response);
            ret = responseWapper;
            HttpClientFlowReplaySpan span = HttpClientFlowReplaySpan.createSpan(httpRequestWrapper, responseWapper);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("httpClient\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("httpClient\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (FlowReplayTrace.isTraced()) {
            FlowReplayTrace.remove();
        }
    }
}

