/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMetricsCollector;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorExclude;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorMvcEndpoint;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class CacheMonitorAutoConfiguration
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorAutoConfiguration.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Value(value="${prometheus.pushgateway.address:}")
    private String pushGatewayAddress;
    private final CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register(this.collectorRegistry);
    private ApplicationContext appContext;
    private final String localIp = NetUtils.getLocalIp();
    private final String prometheusJobName = "cache_monitor";
    private ScheduledExecutorService scheduledThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("duiba-pushgateway-cache", true));

    @Async
    @EventListener(value={MainContextRefreshedEvent.class})
    public void loadAllCacheBean() {
        String[] beans = this.appContext.getBeanDefinitionNames();
        String curEnv = SpringEnvironmentUtils.getCurrentEnv();
        for (String beanName : beans) {
            Field[] fields;
            Object beanObj = this.appContext.getBean(beanName);
            Class<?> beanObjClass = beanObj.getClass();
            if (beanObjClass.getAnnotation(CacheMonitorExclude.class) != null || (fields = beanObj.getClass().getDeclaredFields()).length == 0) continue;
            this.addCache(fields, beanName, beanObj, curEnv);
        }
        this.pushRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCache(Field[] fields, String beanName, Object beanObj, String curEnv) {
        for (Field field : fields) {
            if (field.getAnnotation(CacheMonitorExclude.class) != null) continue;
            boolean isGuava = Cache.class.isAssignableFrom(field.getType());
            boolean isCaffeine = com.github.benmanes.caffeine.cache.Cache.class.isAssignableFrom(field.getType());
            if (!isGuava && !isCaffeine) continue;
            field.setAccessible(true);
            String keyName = String.format("%s-%s", beanName, field.getName());
            try {
                Object cache = null;
                if (isGuava) {
                    cache = field.get(beanObj);
                    CacheMonitorManager.saveCache(cache, keyName);
                }
                if (isCaffeine) {
                    cache = field.get(beanObj);
                    CacheMonitorManager.saveCache(cache, keyName);
                }
                this.cacheMetrics.addCache(keyName, cache, this.localIp, this.currentAppName, curEnv);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private void pushRecord() {
        if (this.cacheMetrics.getSize() == 0L) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.pushGatewayAddress)) {
            return;
        }
        PushGateway pushGateway = new PushGateway(this.pushGatewayAddress);
        HashMap groupingKey = Maps.newHashMap();
        groupingKey.put("ip", this.localIp);
        this.scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                pushGateway.pushAdd(this.collectorRegistry, "cache_monitor", groupingKey);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6307\u6807\u5230pushgateway\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Environment environment = this.appContext.getEnvironment();
        CacheMonitorManager.init(environment, this.currentAppName);
    }

    @Configuration
    public static class CacheMonitorEndpointConfiguration {
        @Bean
        public CacheMonitorMvcEndpoint cacheMonitorEndpointConfiguration() {
            return new CacheMonitorMvcEndpoint();
        }
    }
}

