/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class BootMonitorCheckFilter
implements Filter {
    private static volatile boolean inService = false;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        if (uri.equals("/monitor/check")) {
            if (!inService) {
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(inService ? "OK" : "INVALID");
        } else if (uri.equals("/monitor/stop")) {
            if (!HttpRequestUtils.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = false;
            response.getWriter().write("OK");
        } else if (uri.equals("/monitor/start")) {
            if (!HttpRequestUtils.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = true;
            response.getWriter().write("OK");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    public static void setInService(boolean inService) {
        BootMonitorCheckFilter.inService = inService;
    }
}

