package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by wenqi.huang on 2017/04/18.
 */
@ConfigurationProperties(prefix = "duiba.rocketmq")
public class RocketMqProperties {
    /**
     * Producer属性
     */
    private ProducerProperties producer;
    /**
     * Consumer属性
     */
    private ConsumerProperties consumer;
    /**
     * RocketMQ nameSrv地址
     */
    private String nameSrvAddr;

    public ProducerProperties getProducer() {
        return producer;
    }

    public void setProducer(ProducerProperties producer) {
        this.producer = producer;
    }

    public ConsumerProperties getConsumer() {
        return consumer;
    }

    public void setConsumer(ConsumerProperties consumer) {
        this.consumer = consumer;
    }

    public String getNameSrvAddr() {
        if(nameSrvAddr != null && nameSrvAddr.trim().equals("")){
            return null;
        }
        return nameSrvAddr;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }

    public static class ProducerProperties{
        /**
         * 是否启用RocketMQ生产者
         */
        private Boolean enable = false;

        /**
         * 即ProducerId
         */
        private String group;

        /**
         * 发送超时时间，单位：ms，默认：400ms
         */
        private Integer sendMsgTimeoutMillis = 400;

        public Boolean getEnable() {
            return enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getSendMsgTimeoutMillis() {
            return sendMsgTimeoutMillis;
        }

        public void setSendMsgTimeoutMillis(Integer sendMsgTimeoutMillis) {
            this.sendMsgTimeoutMillis = sendMsgTimeoutMillis;
        }
    }
    public static class ConsumerProperties{
        /**
         * 是否启用RocketMQ消费者
         */
        private Boolean enable = false;

        /**
         * 即ConsumerId
         */
        private String group;

        /**
         * 需要订阅的topic，多个用英文半角逗号隔开
         */
        private String topics;

        /**
         * 消息消费的最大重试次数，默认16
         */
        private Integer maxReconsumeTimes = 16;
        /**
         * 消费线程数量, 不设置时线程池最小大小为20，最大为64。如果你设置了，则最小和最大值都是你设置的值,一般默认即可
         */
        private Integer consumeThreadNums = 0;

        public Boolean getEnable() {
            return enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getMaxReconsumeTimes() {
            return maxReconsumeTimes;
        }

        public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
            this.maxReconsumeTimes = maxReconsumeTimes;
        }

        public Integer getConsumeThreadNums() {
            return consumeThreadNums;
        }

        public void setConsumeThreadNums(Integer consumeThreadNums) {
            this.consumeThreadNums = consumeThreadNums;
        }

        public String getTopics() {
            return topics;
        }

        public void setTopics(String topics) {
            this.topics = topics;
        }
    }
}
