package cn.com.duibaboot.ext.autoconfigure.javaagent;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginBootstrap;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginFinder;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.instrument.Instrumentation;

/**
 * 查找agent-plugin下配置的插件进行拦截,注入代码到相应的类(这个类必须被AppClassLoader加载，否则会报错)
 */
public class PluginAgent {
    private static final Logger logger = LoggerFactory.getLogger(PluginAgent.class.getName());

    public static void agentmain(String args, Instrumentation instrumentation) {
        final PluginFinder pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        new AgentBuilder.Default()
                .ignore(ElementMatchers.nameStartsWith("net.bytebuddy.")
                        .or(ElementMatchers.nameStartsWith("net.sf.cglib."))
                        .or(ElementMatchers.nameStartsWith("org.objectweb.asm."))
                        .or(ElementMatchers.nameStartsWith("java."))
                        .or(ElementMatchers.nameStartsWith("com.sun."))
                        .or(ElementMatchers.nameStartsWith("javax.")))
                .type(pluginFinder.buildMatch()).transform(new AgentBuilder.Transformer() {
            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription,
                                                    ClassLoader classLoader, JavaModule module) {
                AbstractClassEnhancePluginDefine pluginDefine = pluginFinder.find(typeDescription, classLoader);
                if (pluginDefine != null) {
                    DynamicType.Builder<?> newBuilder = pluginDefine.define(typeDescription.getTypeName(), builder, classLoader);
                    if (newBuilder != null) {
                        if(logger.isInfoEnabled()) {
                            logger.info("Finish the prepare stage for " + typeDescription.getName());
                        }
                        return newBuilder;
                    }
                }

                logger.info("Matched class " + typeDescription.getTypeName() + ", but ignore by finding mechanism.");
                return builder;
            }
        }).with(new AgentBuilder.Listener() {
            @Override
            public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {

            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                         boolean loaded, DynamicType dynamicType) {
                if(logger.isInfoEnabled()) {
                    logger.info("On Transformation class " + typeDescription.getName());
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                  boolean loaded) {

            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded,
                                Throwable throwable) {
                if(logger.isInfoEnabled() && !(throwable instanceof IllegalStateException && throwable.getMessage()!=null && throwable.getMessage().startsWith("Cannot resolve type description"))) {
                    logger.info("Failed to enhance class " + typeName, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }
        }).installOn(instrumentation);
    }
}
