package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 此Filter用于对超时请求打印warn日志
 * Created by huangwenqi on 16/12/27.
 */
public class DBTimeProfileFilter implements Filter{

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;

        //不允许浏览器动态嗅探响应内容的类型
//        ((HttpServletResponse)servletResponse).setHeader("x-content-type-options","nosniff");//这个加了对于jsonp请求会有问题。jsonp需要返回类型为text/javascript才行，先去掉

        String uri = request.getRequestURI();
        if(uri.equals("/hystrix.stream")){//对于一些特殊请求不进行计时.
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }

        try {
            DBTimeProfile.start();
            filterChain.doFilter(servletRequest, servletResponse);
        }finally {
            DBTimeProfile.end(uri);
        }
    }

    @Override
    public void destroy() {

    }

}
