/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent;

import com.ea.agentloader.AgentLoader;
import com.ea.agentloader.ClassPathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class AttachJavaAgentListener
implements SpringApplicationRunListener {
    private static final Logger logger = LoggerFactory.getLogger(AttachJavaAgentListener.class);
    private SpringApplication application;
    private static boolean startingCalled = false;

    public AttachJavaAgentListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    public void started() {
        this.starting();
    }

    public void starting() {
        Thread.currentThread().getThreadGroup();
        if (!startingCalled) {
            String jarPath;
            startingCalled = true;
            String agentClass = "cn.com.duibaboot.ext.autoconfigure.javaagent.PluginAgentDelegate";
            try {
                jarPath = this.loadAgentClassesIntoSystemClassLoader(agentClass);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (jarPath != null) {
                AgentLoader.loadAgent((String)jarPath, null);
            } else {
                AgentLoader.loadAgentClass((String)agentClass, null);
            }
        }
    }

    private String loadAgentClassesIntoSystemClassLoader(String agentClass) throws IOException {
        if (AttachJavaAgentListener.class.getClassLoader() != ClassLoader.getSystemClassLoader()) {
            ClassPathUtils.appendToSystemPath((URL)this.writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/byte-buddy-1.7.1.jar!/"));
            ClassPathUtils.appendToSystemPath((URL)this.writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/byte-buddy-agent-1.5.7.jar!/"));
            File jarFile = File.createTempFile("spring/javaagent." + agentClass, ".jar");
            jarFile.deleteOnExit();
            this.createAgentJar(new FileOutputStream(jarFile), agentClass, null, true, true, false);
            return jarFile.toString();
        }
        return null;
    }

    private void createAgentJar(OutputStream out, String agentClass, String bootClassPath, boolean canRedefineClasses, boolean canRetransformClasses, boolean canSetNativeMethodPrefix) throws IOException {
        Manifest man = new Manifest();
        man.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        man.getMainAttributes().putValue("Agent-Class", agentClass);
        if (bootClassPath != null) {
            man.getMainAttributes().putValue("Boot-Class-Path", bootClassPath);
        }
        man.getMainAttributes().putValue("Can-Redefine-Classes", Boolean.toString(canRedefineClasses));
        man.getMainAttributes().putValue("Can-Retransform-Classes", Boolean.toString(canRetransformClasses));
        man.getMainAttributes().putValue("Can-Set-Native-Method-Prefix", Boolean.toString(canSetNativeMethodPrefix));
        JarOutputStream jarOut = new JarOutputStream(out, man);
        this.appendClassToJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/spring-boot-ext-1.2.42.h8.jar!/", jarOut);
        jarOut.flush();
        jarOut.close();
    }

    private URL writeJar(String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        File file = File.createTempFile("spring/spring-", ".jar");
        file.deleteOnExit();
        if (connection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(file));
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                jarOut.putNextEntry(jarEntry);
                InputStream in = jarFile.getInputStream(jarEntry);
                byte[] bs = new byte[128];
                int n = -1;
                while ((n = in.read(bs)) != -1) {
                    jarOut.write(bs, 0, n);
                }
                jarOut.closeEntry();
            }
            jarOut.close();
        }
        URL url1 = file.toURI().toURL();
        System.out.println("write-complete:" + url1.toString());
        return url1;
    }

    private void appendClassToJar(String url, JarOutputStream jarOut) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        if (connection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (!jarEntry.toString().contains("PluginAgentDelegate")) continue;
                jarOut.putNextEntry(jarEntry);
                InputStream in = jarFile.getInputStream(jarEntry);
                byte[] bs = new byte[128];
                int n = -1;
                while ((n = in.read(bs)) != -1) {
                    jarOut.write(bs, 0, n);
                }
                jarOut.closeEntry();
            }
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }

    public static void main(String[] args) {
        System.out.println(ClassLoader.getSystemClassLoader() instanceof URLClassLoader);
    }
}

