/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import com.aliyun.openservices.ons.api.SendResult;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OnsPerfAspect {
    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);

    @Around(value="execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo("onsProducer");
            if (methodName.equals("send")) {
                return new SendResult();
            }
            return null;
        }
        return joinPoint.proceed();
    }
}

