/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.ttl.TransmittableExecutorBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.OnsPerfAspect;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import cn.com.duibaboot.ext.autoconfigure.perftest.RocketMqPerfAspect;
import cn.com.duibaboot.ext.autoconfigure.perftest.SpringDataMongodbPerfAspect;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.aliyun.openservices.ons.api.Consumer;
import com.mongodb.MongoClientURI;
import com.netflix.hystrix.HystrixCommand;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.hystrix.HystrixFeign;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
@ConditionalOnClass(value={TransmittableThreadLocal.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class PerfTestAutoConfiguration {
    @Bean
    public DiscoveryMetadataRegister perftest_DiscoveryMetadataRegister() {
        return new DiscoveryMetadataRegister(){

            @Override
            public void registerMetadata(Map<String, String> appMetadata) {
                appMetadata.put("isPerfTestSupportted", "1");
            }
        };
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    public class PerfTestFeignConfiguration {
        @Bean
        public RequestInterceptor perfTestFeignRequestInterceptor() {
            return new RequestInterceptor(){

                public void apply(RequestTemplate template) {
                    if (PerfTestContext.isCurrentInPerfTestMode()) {
                        template.header("isPerfTestMode", new String[]{"true"});
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={MongoProperties.class, TransmittableThreadLocal.class})
    public static class MongoDbDataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestMongoDbDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<MongoProperties>(){

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<MongoProperties> getBeanType() {
                    return MongoProperties.class;
                }

                @Override
                public Object postProcessBeforeInitialization(MongoProperties bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(MongoProperties bean, String beanName) throws BeansException {
                    SpringDataMongodbPerfAspect.OriginDataBaseUri.put(new MongoClientURI(bean.getUri()).getDatabase(), bean.getUri());
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={AbstractRoutingDataSource.class, TransmittableThreadLocal.class})
    public static class DataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<DataSource>(){

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                    if (!(bean instanceof PerfTestRoutingDataSource)) {
                        PerfTestRoutingDataSource ts = new PerfTestRoutingDataSource((DataSource)bean);
                        ts.afterPropertiesSet();
                        bean = ts;
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, DefaultMQProducer.class, Aspect.class})
    public static class RocketMqPerfConfiguration {
        @Bean
        public RocketMqPerfAspect getRocketMqPerfAspect() {
            return new RocketMqPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, Consumer.class, Aspect.class})
    public static class OnsPerfConfiguration {
        @Bean
        public OnsPerfAspect getOnsPerfAspect() {
            return new OnsPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, MongoTemplate.class, Aspect.class})
    public static class SpringDataMongodbPerfConfiguration {
        @Bean
        public SpringDataMongodbPerfAspect getSpringDataMongodbPerfAspect() {
            return new SpringDataMongodbPerfAspect();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class TransmittableThreadLocalConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor perfTestExecutorServiceBeanPostProcessor() {
            return new TransmittableExecutorBeanPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"/autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication
    public static class WebConfiguration
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            try {
                Field field = registry.getClass().getDeclaredField("registrations");
                field.setAccessible(true);
                List registrations = (List)field.get(registry);
                for (InterceptorRegistration r : registrations) {
                    if (!(r instanceof InternalInterceptorRegistration)) continue;
                    return;
                }
                InternalInterceptorRegistration registration = new InternalInterceptorRegistration(this.pressureTestInterceptor());
                registration.addPathPatterns(new String[]{"/**"});
                if (registrations.isEmpty()) {
                    registrations.add(registration);
                } else {
                    registrations.add(0, registration);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private HandlerInterceptor pressureTestInterceptor() {
            return new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                    boolean isTestMode = false;
                    String testInParameter = request.getParameter("_duibaPerf");
                    if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
                        isTestMode = true;
                    } else {
                        Cookie[] cookies = request.getCookies();
                        if (cookies != null) {
                            for (Cookie cookie : cookies) {
                                if (!"_duibaPerf".equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                                isTestMode = true;
                            }
                        }
                    }
                    if (!isTestMode && "true".equals(request.getHeader("isPerfTestMode"))) {
                        isTestMode = true;
                    }
                    if (isTestMode) {
                        TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)true);
                    }
                    return true;
                }

                public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                }
            };
        }

        private class InternalInterceptorRegistration
        extends InterceptorRegistration {
            public InternalInterceptorRegistration(HandlerInterceptor interceptor) {
                super(interceptor);
            }
        }
    }

    public static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<Boolean> threadLocal2PressureTest = new TransmittableThreadLocal();
    }
}

