/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin;

import cn.com.duibaboot.ext.autoconfigure.plugin.PluginDefine;
import cn.com.duibaboot.ext.autoconfigure.plugin.exception.IllegalPluginDefineException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PluginCfg {
    INSTANCE;

    private static final Logger logger;
    private List<PluginDefine> pluginClassList = new ArrayList<PluginDefine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(InputStream input) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String pluginDefine = null;
            while ((pluginDefine = reader.readLine()) != null) {
                try {
                    PluginDefine plugin;
                    if (pluginDefine == null || pluginDefine.trim().length() == 0 || !(plugin = PluginDefine.build(pluginDefine)).enable()) continue;
                    this.pluginClassList.add(plugin);
                }
                catch (IllegalPluginDefineException e) {
                    logger.error(String.format("Failed to format plugin(%s) define.", pluginDefine), (Throwable)e);
                }
            }
        }
        finally {
            input.close();
        }
    }

    public List<PluginDefine> getPluginClassList() {
        return this.pluginClassList;
    }

    static {
        logger = LoggerFactory.getLogger(PluginCfg.class);
    }
}

