/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin;

import cn.com.duibaboot.ext.autoconfigure.plugin.conf.Config;
import cn.com.duibaboot.ext.autoconfigure.plugin.exception.IllegalPluginDefineException;
import cn.com.duibaboot.ext.autoconfigure.plugin.util.StringUtil;

public class PluginDefine {
    public static final String PLUGIN_OFF_PREFIX = "[OFF]";
    private String name;
    private String defineClass;
    private State state;

    private PluginDefine(String name, String defineClass, State state) {
        this.name = name;
        this.defineClass = defineClass;
        this.state = state;
    }

    public static PluginDefine build(String define) throws IllegalPluginDefineException {
        if (StringUtil.isEmpty(define)) {
            throw new IllegalPluginDefineException(define);
        }
        String[] pluginDefine = define.split("=");
        if (pluginDefine.length != 2) {
            throw new IllegalPluginDefineException(define);
        }
        String pluginName = pluginDefine[0];
        String defineClass = pluginDefine[1];
        if (pluginName.toUpperCase().startsWith(PLUGIN_OFF_PREFIX)) {
            return new PluginDefine(pluginName.substring(PLUGIN_OFF_PREFIX.length()), defineClass, State.OFF);
        }
        return new PluginDefine(pluginName, defineClass, State.ON);
    }

    public boolean enable() {
        return !this.forceDisable() || this.forceEnable();
    }

    private boolean forceDisable() {
        return this.state != State.ON || Config.Plugin.DISABLED_PLUGINS.contains(this.name);
    }

    private boolean forceEnable() {
        return this.state == State.OFF && Config.Plugin.FORCE_ENABLE_PLUGINS.contains(this.name);
    }

    public String getDefineClass() {
        return this.defineClass;
    }

    private static enum State {
        OFF,
        ON;

    }
}

