/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.plugin.PluginException;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.loader.InterceptorInstanceLoader;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorInter {
    private static final Logger logger = LoggerFactory.getLogger(ConstructorInter.class);
    private InstanceConstructorInterceptor interceptor;

    public ConstructorInter(String constructorInterceptorClassName, ClassLoader classLoader) throws PluginException {
        try {
            this.interceptor = (InstanceConstructorInterceptor)InterceptorInstanceLoader.load(constructorInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceConstructorInterceptor.", t);
        }
    }

    @RuntimeType
    public void intercept(@This Object obj, @AllArguments Object[] allArguments) {
        try {
            EnhancedInstance targetObject = (EnhancedInstance)obj;
            this.interceptor.onConstruct(targetObject, allArguments);
        }
        catch (Throwable t) {
            logger.error("ConstructorInter failure.", t);
        }
    }
}

