package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.util.Arrays;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfTestContext {
    private static final Logger logger = LoggerFactory.getLogger(PerfTestContext.class);
    private PerfTestContext(){}

    /**
     * 判断当前是否是压测请求
     *
     * @return
     */
    public static boolean isCurrentInPerfTestMode(){
        Boolean b = PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        return b != null && b == true;
    }

    public static void setPerfTestMode(Boolean val) {
        PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.set(val);
    }
    public static void debugInfo(String typeName){
        if (logger.isDebugEnabled()) {
            Arrays.stream(Thread.currentThread().getStackTrace()).filter(x->x.getClassName().startsWith("cn.com.duiba.")).forEach(x->
                    logger.debug("Perf {} From {}:{}:{}",typeName, x.getClassName(),x.getMethodName(),x.getLineNumber())
            );
        }
    }
}
